/**
 *
 * \file        hprfgw_rfslaveintftohost.h
 *
 * \brief       The RF slave device interface to host 		
 *
 * \detial      
 * \author      Hazrat Shah	
 *
 * \date        11/28/2006
 * \warning		
 * \note
 * \review	
 *
 */
#ifndef _HPRFGW_RFSLAVEINTTOHOST_H_
#define _HPRFGW_RFSLAVEINTTOHOST_H_

//#include "datatypes.h"
#include "hprfgw_rfSharedDefs.h"
#include "hprfgw_rfDesc.h"

#define	MAX_GATEWAY_IN_ACQUIRE_REC_SIZE	100
typedef	struct	{
	UINT8	uid[UID_MAX_SIZE];
	UINT16	panid;
	UINT8	channel;
	UINT8	addrmode;
	UINT8	linkquality;
	UINT8	name[GATEWAY_NAME_MAX_SIZE];
}	TYPE_GATEWAY_IN_ACQUIRE_LIST;

enum HPRF_STARTUP_EVENT {
    HPRF_STARTUP_APP_READY       = 0x0001,
    HPRF_STARTUP_HEARTBEAT_READY = 0x0002,
    HPRF_STARTUP_REC_READY       = 0x0004,
    HPRF_STARTUP_RESULTCODE_READY= 0x0008,
    HPRF_STARTUP_RETRY_READY     = 0x0010,
    HPRF_STARTUP_TRANS_READY     = 0x0020,
    HPRF_STARTUP_ALL_READY       =\
        (HPRF_STARTUP_APP_READY        |\
         HPRF_STARTUP_HEARTBEAT_READY  |\
         HPRF_STARTUP_REC_READY        |\
         HPRF_STARTUP_RESULTCODE_READY |\
         HPRF_STARTUP_RETRY_READY      |\
         HPRF_STARTUP_TRANS_READY)
};

////////////////////////////////////////////////////////////////////////////////
//	Definitions
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//	Data Prototypes	
////////////////////////////////////////////////////////////////////////////////

typedef	struct {
	INT32	(*pF_GetGatewayUID_PANID_ADDRMODE) (BOOL *pUidValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *pAddrMode, UINT8 *defUID, UINT16 defPanid, UINT8 defAddrMode);
	INT32	(*pF_GetLocalDeviceUID_PANID) (BOOL *pUidValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *defUID, UINT16 defPanid);
	INT32	(*pF_StoreGatewayUID_PANID) (UINT8 *pUID, UINT16 PANID, UINT8 AddrMode);
	INT32	(*pF_StoreGatewayName) (UINT8 *pName);
	INT32	(*pF_StoreLocalDeviceUID_PANID) (UINT8 *pUID, UINT16 PANID);
	INT32	(*pF_StoreLocalDeviceUID) (UINT8 *pUID);
	INT32	(*pF_StoreLocalDevicePANID) (UINT16 PANID);
	INT32	(*pF_ProcessCresnetPacket) (UINT8 *pBuf, UINT16 BufLen);
	INT32	(*pF_LinkReply) (BOOL Linked, BOOL CSStatus);
	INT32	(*pF_RFCommunicationError) (BOOL SeqErr, BOOL SegErr);
	INT32	(*pF_BufferOverFlows) (BOOL TxBuf, BOOL RxBuf);
	INT32	(*pF_ProcessLocalCresnetPacket) (UINT8 *pBuf, UINT16 BufLen);
	INT32	(*pF_GetRetryCount) (UINT8 *count, UINT8 defCount);		
	INT32	(*pF_StoreRetryCount) (UINT8 count);		
	INT32	(*pF_GetRetryDelay) (UINT8 *RetryDly, UINT8 Cnt, UINT8 *defRetryDly);	
	INT32	(*pF_StoreRetryDelay) (UINT8 RetryDly, UINT8 Index);	
	INT32	(*pF_GetPowerLevel) (UINT16 *powerLevel, UINT16 defPowerLevel);
	INT32	(*pF_StorePowerLevel) (UINT16 powerLevel);
	INT32	(*pF_GetChannel) (UINT8 *Channel, UINT8 defChannel);
	INT32	(*pF_StoreChannel) (UINT8 Channel);	
	INT32	(*pF_GetCCAEnergyDetectThr) (UINT8 *ccaThres, UINT8 defCcaThres);	
	INT32	(*pF_StoreCCAEnergyDetectThr) (UINT8 ccaThres);	
	INT32	(*pF_GetRSSIPowerCompOffset) (UINT8 *rssiOffset, UINT8 defRssiOffset);	
	INT32	(*pF_StoreRSSIPowerCompOffset) (UINT8 rssiOffset);	
	INT32	(*pF_GetResultCodeTimeout) (UINT16 *timeout, UINT16 defTimeout);	
	INT32	(*pF_StoreResultCodeTimeout) (UINT16 timeout);	
	INT32	(*pF_GetHeartBeatRate) (UINT8 *heartBeatRate, UINT8 defHeartBeatRate);
	INT32	(*pF_StoreHeartBeatRate) (UINT8 heartBeatRate);
	INT32	(*pF_GetIDString) (INT8 *pBuf, UINT8 * count);
	INT32	(*pF_AcquireUpdate) (TYPE_GATEWAY_IN_ACQUIRE_LIST* pAcquireResult, UINT8 NoofAcquireEntries, BOOL Finished);
	INT32	(*pF_ControlSystemConnectionStatusChange) (BOOL CSStatus, BOOL SendUpdateReq);
	INT32	(*pF_GatewayConnectionStatusChange) (BOOL Status);
	INT32	(*pF_GetRFID) (UINT8 *rfID);
	INT32	(*pF_GetTSID) (UINT32 *tsID);
	INT32	(*pF_GetDeviceOptions) (UINT8 *devOpts);
	INT32	(*pF_TransmitPipeOverFlowOccured) (UINT32 index);
	INT32	(*pF_IsRFTxDebugTraceEnabled)(BOOL *isEnabled);
	INT32	(*pF_IsRFRxDebugTraceEnabled)(BOOL *isEnabled);
	INT32	(*pF_RFReceiverIndicatorFlash)(void);
	INT32	(*pF_RFTransmitIndicatorFlash)(void);
	INT32	(*pF_DeviceLinkLost) (UINT8 rfid);			
	INT32	(*pF_DeviceLinkFound) (UINT8 rfid);	
	INT32	(*pF_CalculateBlockCRC16)(UINT16 len, UINT16 *crc, INT8 *pbuf);
	INT32	(*pF_GetDeviceDataField)(UINT8 fieldno, INT8 *pbuf, UINT16 *plen);
	INT32	(*pF_StartupWait)(enum HPRF_STARTUP_EVENT signal_event);
	INT32	(*pF_ConsolePrintf)(const char* format,...);
	INT32	(*pF_ErrorPrintf)(const char* format,...);
	INT32	(*pF_ErrorHandler)(char *msg);
	INT32	(*pF_HwDelayMsec)(UINT32 ms);
	INT32	(*pF_HwDelayUsec)(UINT32 ms);
	INT32	(*pF_GetTime)(long *time);
	INT32	(*pF_GetDate)(short *month,short *day,short *year);
	INT32	(*pF_SystemError)(int error);
	INT32	(*pF_GetAddressMode)(UINT8 *addrMode, UINT8 defAddrMode);
	INT32	(*pF_StoreAddressMode)(UINT8 addrMode);
	INT32	(*pF_GetShortAddress)(UINT16 *shortAddr, UINT16 defShortAddr);
	INT32	(*pF_StoreShortAddress)(UINT16 shortAddr);
	INT32	(*pF_AcquireStartIndication)(void);
	INT32	(*pF_AcquireStopIndication)(void);
	INT32	(*pF_IsUIDValid) (BOOL *pvalid);
	INT32	(*pF_GetLocalDeviceRFLinkLQIThr) (UINT8 *pLQI, UINT8 defaultLQI);
	INT32	(*pF_StoreLocalDeviceRFLinkLQIThr) (UINT8 LQI);
	INT32	(*pF_GetRetryCountOnConnectionReq) (UINT8 *count, UINT8 defCount);	
	INT32	(*pF_StoreRetryCountOnConnectionReq) (UINT8 count);
	INT32	(*pF_GetPreLinkQueryPacketCnt) (UINT8 *count, UINT8 defCount);
	INT32	(*pF_StorePreLinkQueryPacketCnt) (UINT8 count);	
#ifndef	RF_NETWORK_MASTER_DEVICE	
    INT32	(*pF_InitRoamingDescriptiveTable)(void);
	INT32	(*pF_SetRoamingGatewayUID_PANID)(UINT8 *gwuid,UINT16 panid);
#else
	INT32	(*pF_GetGatewayRoamingSupport) (UINT8 * roaming);	
	INT32	(*pF_StoreGatewayRoamingSupport) (UINT8 roaming); 
	INT32	(*pF_GetPowerBoost) (UINT8 * powerBoost);
	INT32	(*pF_StorePowerBoost) (UINT8 powerBoost); 
#endif
}	TYPE_INTERFACE_TO_HOST_APP; 
extern const TYPE_INTERFACE_TO_HOST_APP RFIntHostApp;

extern DM_RESOURCE_HANDLE g_startupEventGroup;
////////////////////////////////////////////////////////////////////////////////
//	Function declaractions	
////////////////////////////////////////////////////////////////////////////////


#endif
